/*
 * JGfx.hpp
 *
 * Enumerations etc. for graphics systems
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jgfx_h
#define _jgfx_h

class JGfx
{
 public:

   struct fgMix
   {
      enum type {
         normal,
         or,
         overPaint,
         xor      = 4,
         invisible,
         and,
         zero     = 9,
         inverse1 = 12,
         inverse2 = 14,
         one      = 17
      };
   };

   struct bgMix
   {
      enum type {
         normal,
         or,
         overPaint,
         xor          = 4,
         invisible,
         and,
         zero         = 9,
         inverse1     = 12,
         inverse2     = 14,
         one          = 17,
         transparent1,  // doesn't copy bits which are the target's bg color
         transparent2   // only copies bits which are the target's bg color
      };
   };

   struct line
   {
      struct end
      {
         enum type {
            normal,
            flat,
            square,
            round
         };
      };

      struct join
      {
         enum type {
            normal,
            bevel,
            round,
            mitre
         };
      };

      struct type
      {
         enum typ {
            normal,
            dotted,
            shortDash,
            dashDot,
            doubleDots,
            longDash,
            dashDotDot,
            solid,
            invisible,
            dotted2
         };
      };

      struct width
      {
         enum type {
            normal,
            thick
         };
      };

   };

   struct marker
   {
      enum sym {
         normal,
         cross,
         plus,
         diamond,
         square,
         sixPointStar,
         eightPointStar,
         solidDiamond,
         solidSquare,
         dot,
         circle,
         blank
      };
   };

   struct pattern
   {
      enum sym {
         normal,
         dense1,
         dense2,
         dense3,
         dense4,
         dense5,
         dense6,
         dense7,
         dense8,
         vert,
         horz,
         diag1,
         diag2,
         diag3,
         diag4,
         blank,
         solid
      };
   };

   struct units
   {
      enum type {
         pels     = 0x08,
         loMetric = 0x0c,   // 0.1mm
         hiMetric = 0x10,   // 0.01mm
         loImp    = 0x14,   // 0.01"
         hiImp    = 0x18,   // 0.001"
         twips    = 0x1c    // 1/1440"
      };
   };

   struct rop     // rendering operations
   {
      enum type {
         normal = 0xcc,
         invert = 0x66
      };
   };

   struct icon
   {
      enum type {
         normal,
         halftoned,
         inverted,
         mini = 4
      };
   };

};

#endif
