/*
 * JHelp.hpp
 *
 * Help manager class; interface to the IPF
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jhelp_h
#define _jhelp_h

#include "JLib.h"
#include "JStr.hpp"
#include "JModule.hpp"

class JWindow;
class JResID;

// you can attach an object descended from here to be called when the user
// requests a tutorial..
class JTutorial
{
   JStr nme;

 public:
   JTutorial( const char *name) : nme( name) {}
   JStr name() const { return nme; }
   virtual void operator () () = 0;
};

// This represents a page of IPF, identified when you wrote it.
class JHelpID
{
   ulong id;

 public:
   JHelpID( ulong i = 0) : id( i) {}
   ulong ID() const               { return id; }
   operator ulong () const        { return id; }
   JHelpID &operator = ( const JHelpID &copy) { id = copy.id; return *this; }
};

// This represents an instance of the help manager; note that you shouldn't
// be creating any of these, there's a static instance defined later on...
class JHelpManager
{
   friend class JHelpMsgHandler;

 public:
   JHelpManager();
  ~JHelpManager();

   // call to set up the dynamic help model;
   // NB call BEFORE you create any frame windows which use help
   JHelpManager &initialise( const char *library, const char *title,
                             JTutorial *tut = 0);
   // call to set up the resource-based help model
   JHelpManager &initialise( const char *library, const char *title,
                             const JResID &id,
                             const JModule &mod = JModule::theResMod,
                             JTutorial *tut = 0);
   enum model {
      resource,
      dynamic,
      none
   };

   // query the help model
   JHelpManager::model helpModel() const { return hModel; }

   // set the general help ID. This page is displayed when IPF's bored, feeling
   // inadequate, or doesn't quite know what to do next.
   JHelpManager &setGeneralID( const JHelpID &h);
   JHelpManager &setKeysHelpID( const JHelpID &h);

   // display various pages
   JHelpManager &showHelp( const JHelpID &h);
   JHelpManager &showIndex();
   JHelpManager &showContents();
   JHelpManager &showKeysHelp();
   JHelpManager &showUsingHelp();

   // tell ipf what to show when user asks for help on help
   JHelpManager &replaceUsingHelp( const JHelpID &h);

   // set up current window chain; only needed for resource based model
   JHelpManager &associate( JWindow *w);

   // set current active window. Used internally.
   JHelpManager &setActiveWindow( JWindow *w);

 private:
   JTutorial *tut;
   JWindow *help;
   model    hModel;
   JHelpID  generalID;
   JHelpID  keysHelp;
};

extern JHelpManager HelpManager;

#endif
