/*
 * JIcon.hpp
 *
 * Icon class - for display, pointer setting etc.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jicon_h
#define _jicon_h

#include "JLib.h"
#include "JModule.hpp"

class JResID;
class JPoint;
class JBitmap;

class JIconData;

class JIcon
{
   JIconData *data;

   friend class JIconData;

 public:
   // wrapper and creator ctors; wrapper won't delete the icon when done
   JIcon( ulong hIcon);
   // consult the pm ref for the format of this bitmap!
   JIcon( const JBitmap &bmp, const JPoint &hot, BOOL ptrStretch = false);

   // copy constructor (erm)
   JIcon( const JIcon &copy);

   // load from the resource module
   JIcon( const JResID &id, const JModule &mod = JModule::theResMod);

  ~JIcon();

   // access
   operator ulong ();
   JBitmap  getBitmap();
   JPoint   getHotspot();
   ulong    handle() const;

   // access to system pointer icons
   enum sys {
      arrow = 1,
      i_beam,
      clock,
      size,
      move,
      size_nwse,
      size_nesw,
      size_ew,
      size_ns,
      appl,
      info,
      question,
      error,
      warning,
      no_entry = 18,
      file,
      folder,
      multfiles,
      program
   };
   static JIcon sysPointer( sys type, BOOL need_private_copy = true);
};

#endif
