/*
 * JKeyH.hpp
 *
 * Keypress (WM_CHAR) handler and event
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jkeyh_h
#define _jkeyh_h

#include "JLib.h"
#include "JEvent.hpp"
#include "JHandler.hpp"

class JKeyEvent : public JEvent
{
 public:
   JKeyEvent( JEventData *e) : JEvent( e) {}

   enum vkeys {
      button1 = 0x01,
      button2,
      button3,
      brk,
      backspace,
      tab,
      backTab,
      newLine,
      shift,
      ctrl,
      alt,
      altG,
      pause,
      capsLock,
      escape,
      space,
      pageUp,
      pageDown,
      end,
      home,
      left,
      up,
      right,
      down,
      printScreen,
      insert,
      del,
      scrollLock,
      numLock,
      enter,
      sysReq,
      f1,
      f2,
      f3,
      f4,
      f5,
      f6,
      f7,
      f8,
      f9,
      f10,
      f11,
      f12,
      f13,
      f14,
      f15,
      f16,
      f17,
      f18,
      f19,
      f20,
      f21,
      f22,
      f23,
      f24,
      clear = 0x39,
      copy =  0x3F
   };

   char  chr() const       { return e->mp2.s1(); }
   vkeys vk() const        { return (vkeys) e->mp2.s2(); }
   uchar repeat() const    { return e->mp1.c3(); }
   uchar scancode() const  { return e->mp1.c4(); }

   BOOL  hasAlt() const;
   BOOL  hasShift() const;
   BOOL  hasCtrl() const;
   BOOL  isClear() const   { return !( hasCtrl() | hasShift() | hasAlt()); }

   // this class just passes on PM's opinion of what's valid.  Be aware that
   // when 'isVk' is false, 'chr' is likely to be valid, whatever the state
   // of 'isChar'.  Go figure.
   BOOL  isVk() const;
   BOOL  isChar() const;
   BOOL  isKeyUp() const;
};

// Handler
class JKeyHandler : public JHandler
{
 public:
   JKeyHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL keypress( const JKeyEvent &) { return false; }
};

#endif
