/*
 * JList.hpp
 *
 * Linked list; really used for implementing stacks & queues
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jlist_h
#define _jlist_h

#include "JLib.h"
#include "JExcept.hpp"

// this isn't really a collection in the sense of others; it doesn't hold
// objects, just pointers to them.

// element type T
template <class T>
class JList
{
 protected:
   struct link
   {
      T *t;
      link *next, *prev;
      link( T *el) : t( el), next( 0), prev( 0) {}
   };

   link *first, *last;
   ulong els;

 public:
   JList() : first( 0), last( 0), elements( 0) {}
   virtual ~JList()
   {
      link *l = first, *next;
      while( l) {
         next = l->next;
         delete l;
         l = next;
      }
   }

   JList<T> &append( T *el)
   {
      link *l = new link( el);
      if( last) {
         last->next = l;
         l->prev = last;
         last = l;
      } else {
         first = last = l;
      }
      els++;
      return self;
   }

   JList<T> &prepend( T *el)
   {
      link *l = new link( el);
      if( first) {
         first->prev = l;
         l->next = first;
         first = l;
      } else {
         first = last = l;
      }
      els++;
      return self;
   }

   ulong elements() const { return els; }

   T *getFirst()
   {
      T *t = 0;
      if( !els) jlib_throw( new JBoundsError( "element"));
      else {
         link *l = first;
         first = first->next;
         if( first) first->prev = 0;
         else last = 0;
         els--;
         t = l->t;
         delete l;
      }
      return t;
   }

   T *getLast()
   {
      T *t = 0;
      if( !els) jlib_throw( new JBoundsError( "element"));
      else {
         link *l = last;
         last = last->prev;
         if( last) last->next = 0;
         else first = 0;
         els--;
         t = l->t;
         delete l;
      ]
      return t;
   }

   T *peekFirst()
   {
      T *t = 0;
      if( !els) jlib_throw( new JBoundsError( "element"));
      else t = first->t;
      return t;
   }

   T *peekLast()
   {
      T *t = 0;
      if( !els) jlib_throw( new JBoundsError( "element"));
      else t = last->t;
      return t;
   }
};

// Queue
template <class T>
class JQueue : protected JList<T>
{
   typedef JList<T> super;

 public:
   JQueue() : super() {}

   JQueue<T> &enqueue( T *t)   { super::append( t); return self; }
   T         *peek()           { return super::peekFirst(); }
   T         *dequeue()        { return super::getFirst(); }
   ulong      elements() const { return super::elements(); }
};

// Stack
template <class T>
class JStack : protected JList<T>
{
   typedef JList<T> super;

 public:
   JStack() : super() {}

   JStack<T> &push( T *t)      { super::append( t); return self; }
   T         *peek()           { return super::peekLast(); }
   T         *pop()            { return super::getLast(); }
   ulong      elements() const { return super::elements(); }
};

#endif
