/*
 * JMParam.hpp
 *
 * MParam & MResult wrappers
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmpmr_h
#define _jmpmr_h

#include "JLib.h"

#define mkpv(l,h) (void*)(((ushort)(l)) | ((ulong)((ushort)(h))) << 16)

class JMP
{
   void * value;

 public:
   JMP() : value( 0)                {}
   JMP( ulong u) : value( (void*)u) {}
   JMP( short s, short t) : value( mkpv(s, t)) {}
   JMP( const void *v) : value( (void*)v) {}
   void * operator ()() const       { return value; }
   operator ulong () const          { return (ulong) value; }
   operator void * () const         { return value; }
   short s1() const                 { return (ushort)((ulong) value); }
   short s2() const                 { return (ushort)((ulong) value >> 16); }
   char  c1() const                 { return (uchar)((ulong) value); }
   char  c2() const                 { return (uchar)((ulong) value >> 8); }
   char  c3() const                 { return (uchar)((ulong) value >> 16); }
   char  c4() const                 { return (uchar)((ulong) value >> 24); }
   void set( short s1, short s2)    { value = mkpv( s1, s2); }
   void operator = ( unsigned long u) { value = (void*) u; }
   void operator = ( void * v)        { value = v; }
};

typedef JMP JMR;

#endif
