/*
 * JMenu.hpp
 *
 * Menu - bar, pulldown, popup - class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmenu_h
#define _jmenu_h

#include "JLib.h"
#include "JWindow.hpp"
#include "JFrame.hpp"

class JModule;
class JBitmap;
class JResID;
class JStr;

class JMenu : public JWindow
{
 public:
   JMenu( ulong h) : JWindow( h) {}   // wrapper
   JMenu( const JResID &id, JWindow *owner = &JWindow::theObjectWindow,
          const JModule &mod = JModule::theResMod);  // from resource
   JMenu( JMother *owner, JWindow *parent, ulong id = JFrame::idMenu,
          BOOL bar = false);  // make an empty menu

   // removing items from the menu
   JMenu &removeItem( short item, BOOL del = false);

   // adding items to the menu
   JMenu &addItem( const char *text, short id, short pos = -1, JMenu *sub = 0);
   JMenu &addItem( const JBitmap &b, short id, short pos = -1, JMenu *sub = 0);
   JMenu &addSeparator( short id = 0, short pos = -1);
   JMenu &addSubMenu( short id, JMenu *sub);

   // toggles the 'ticked' state & returns the new - current - tickedness
   BOOL toggleItem( short id) const;
   JMenu &tick( short Id, BOOL set = true);

   // set item enablement
   JMenu &enableItem( short id, BOOL yes = true);
   JMenu &disableItem( short id) { return enableItem( id, false); }

   // enable all items on menu
   JMenu &enableItems( BOOL yes = true);
   JMenu &disableItems() { return enableItems( false); }

   // item text
   JStr itemText( short id) const;
   JMenu &setItemText( short id, char *s);

   // get the submenu hanging off the item
   JMenu getSubMenu( short id) const;

   // conditional cascade submenus
   JMenu &makeCascade( short defaultEntry);
   JMenu &setDefault( short defaultEntry);
   short  getDefault() const;

   // context menu support
   JMenu &popUp( JWindow &owner, const JPoint &pos);
   JMenu &popUp( JWindow &owner); // over mouse pointer

   // system menu ids
   enum sysMenu {
      Restore    = 0x8008,
      Move       = 0x8001,
      Size       = 0x8000,
      Minimize   = 0x8002,
      Maximize   = 0x8003,
      Hide       = 0x802a,
      Close      = 0x8004,
      Next       = 0x8005,
      WindowList = 0x8011
   };
};

#endif
