/*
 * JModule.hpp
 *
 * Dynamic Link Library (mainly for resource dlls)
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmodule_h
#define _jmodule_h

#include "JLib.h"

typedef int ( _System _pfn) ();
typedef _pfn *pfn;

class JModule
{
   ulong hMod;

 public:
   JModule() : hMod( 0)    {}
   JModule( const char *name)    { load( name); }
  ~JModule();

   operator ulong () const { return handle(); }
   ulong handle() const    { return hMod; }

   void load( const char *name);

   static char *nameOf( ulong hModule);
   static ulong handleOf( const char *c);

   pfn getProc( ulong ord) const;
   pfn getProc( const char *name) const;

   // this is the resource module for the application.  It defaults to the
   // .exe file, to load your own resource dll just call
   // JModule::theResMod.load(..)
   static JModule theResMod;

   // this is JLib's resource module; you ought not to change it!
   static JModule myResMod;
};

#endif
