/*
 * JMother.hpp
 *
 * Class that provides frame-like behaviour
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmother_h
#define _jmother_h

#include "JLib.h"
#include "JWindow.hpp"
#include "JModule.hpp"

class JProfile;
class JAccelTable;
class JMenu;
class JIcon;
class JStr;
class JResID;
class JCmdEvent;
class JHelpID;
class JMotherData;

class JMother : public JWindow
{
   JMotherData *data;
   friend class JMotherHandler;

 protected:
   JMother( BOOL dlg);

 public:
  ~JMother();

   // frame furniture
   // Note that if you use a setFoo( Foo *) method, then the window will
   // look after that pointer & delete the object when it dies itself.
   // This is a bit unusual, and arguably should be altered.
   JMother &setIcon( JResID id, const JModule &m = JModule::theResMod);
   JMother &setIcon( JIcon *icon);
   JIcon   *getIcon();

   JMother      &setAccel( JResID id, const JModule &m = JModule::theResMod);
   JMother      &setAccel( JAccelTable *table);
   JAccelTable *getAccelTable();

   JMother &setMenu( JResID id, const JModule &m = JModule::theResMod);
   JMother &setMenu( JMenu *menu);
   JMenu   *getMenu();

   JMother &showMenu( BOOL show = true);
   JMother &hideMenu() { return showMenu( false); }

   JMother &setAll( JResID id, const JModule &m = JModule::theResMod);

   // INI file loading & saving of position
   JMother &loadPos( JProfile &prf, const char *app, BOOL resave = true);
   JMother &savePos( JProfile &prf, const char *app);

   // system menu; IDs are defined in JMenu.hpp
   JMenu *getSystemMenu();

   // tasklist support
   JMother &showInTasklist( BOOL show = true);
   JMother &removeFromTasklist() { return showInTasklist( false); }
   JMother &setText( const char *title);

   // get client rectangle
   // !! ought to say what coord system this is in
   JRect clientRect() const;

   // size window so that the client is of this size
   JMother &sizeClientTo( const JSize &sz);

   // called when the window is asked to close.
   // the default returns false which makes the message loop end.
   // over-ride to return true, which dumps the message.
   virtual BOOL closing() { return false; }

   // built-in WM_[SYS]COMMAND handlers
   // return true to stop the default action from taking place
   virtual BOOL command( const JCmdEvent &)    { return false; }
   virtual BOOL sysCommand( const JCmdEvent &) { return false; }

   // minimum/maximum sizes of the frame.
   // we default to min = 0, 0, max = screensize.
   JMother &setMinimumSize( const JSize &size);
   virtual JSize &minimumSize();
   JMother &setMaximumSize( const JSize &size);
   virtual JSize &maximumSize();

   // Help manager support. When using the dynamic help model, the help page
   // defined with this helpID is shown on a keypress f1 or a press of bs_help
   // pushbutton. If you don't define a helpid in this way, the help manager
   // will try the window id.
   JMother &setHelpID( const JHelpID &id);
   JHelpID  helpID() const;
};

#endif
