/*
 * JMouseH.hpp
 *
 * Mouse event handlers and events
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmouseh_h
#define _jmouseh_h

#include "JLib.h"
#include "JHandler.hpp"
#include "JEvent.hpp"
#include "JCoord.hpp"

// Here we have handlers to handle mouse clicks, moves.
// Also a handler for the pointer entering & leaving the window.
// I belive this needs either Warp4 or at least fixpak 32 on Warp3 to work.
class JMouseEvent : public JEvent
{
   BOOL i;

 public:
   JMouseEvent( JEventData *e, BOOL iss = false) : JEvent( e), i( iss) {}

   JPoint pos() const; // relative to the window
};

class JClickEvent : public JMouseEvent
{
 public:
   JClickEvent( JEventData *e) : JMouseEvent( e) {}

   // refer to conditions at time event happened (thankfully!)
   BOOL hasAlt() const;
   BOOL hasShift() const;
   BOOL hasCtrl() const;
};

// There are two types of handlers supplied here; you should use one or the
// other.
class JMouseHandler : public JHandler
{
 public:
   JMouseHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL button1click( const JClickEvent &)        { return false; }
   virtual BOOL button1doubleClick( const JClickEvent &)  { return false; }
   virtual BOOL button1down( const JClickEvent &)         { return false; }
   virtual BOOL button1up( const JClickEvent &)           { return false; }

   virtual BOOL button2click( const JClickEvent &)        { return false; }
   virtual BOOL button2doubleClick( const JClickEvent &)  { return false; }
   virtual BOOL button2down( const JClickEvent &)         { return false; }
   virtual BOOL button2up( const JClickEvent &)           { return false; }

   virtual BOOL chord( const JClickEvent &)               { return false; }
   virtual BOOL mouseMove( const JMouseEvent &)           { return false; }

};

class JCUAMouseHandler : public JHandler
{
 public:
   JCUAMouseHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL beginSelect( const JMouseEvent &)     { return false; }
   virtual BOOL endSelect( const JMouseEvent &)       { return false; }
   virtual BOOL singleSelect( const JMouseEvent &)    { return false; }
   virtual BOOL textEdit( const JMouseEvent &)        { return false; }
   virtual BOOL open( const JMouseEvent &)            { return false; }
   virtual BOOL contextMenu( const JMouseEvent &)     { return false; }
   // note drag ops handled by JDragHandler
};

// Trigger when the user moves the mouse into or out of the window
// I am doc-less, so don't know what the parameters are; they look like window
// handles, I suspect mp1 == new hwnd, mp2 == old hwnd (under the mouse)
class JMouseEnterExitHandler : public JHandler
{
 public:
   JMouseEnterExitHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   virtual BOOL mouseEnter( const JEvent &) { return false; }
   virtual BOOL mouseLeave( const JEvent &) { return false; }
};

#endif
