/*
 * JMsgBox.hpp
 *
 * JLib message boxes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmsgbox_h
#define _jmsgbox_h

#include "JLib.h"
#include "JDialog.hpp"

class JMsgBoxData;
// This class provides a message box, which can be application- or system- or
// non-modal. The box is centered over its owner, if shown modally, or a window
// given at time of showing otherwise.

// To use help, call JMsgBox::setHelpID with the appropriate ID and use a type
// which includes help.
class JMsgBox : public JDialog
{
   JMsgBoxData *data;
   ulong runDlg( BOOL = false);

 public:

   // returned from show method
   static const ushort
      Ok,
      cancel,
      yes,
      no,
      retry,
      abort,
      ignore,
      help;

   // button types
   enum buttons {
      ok                     = 0x01,
      okCancel               = 0x03,
      yesNo                  = 0x0c,
      retryAbortIgnore       = 0x70,
      okHelp                 = 0x81,
      okCancelHelp           = 0x83,
      yesNoHelp              = 0x8c,
      retryAbortIgnoreHelp   = 0xf0
   };

   // type of message; determines type of icon displayed
   enum type {
      informational,
      question,
      warning,
      error
   };

   // pass 0 as owner if you intend not to show the box modally
   JMsgBox( JWindow *owner, const char *msg, const char *title = "Message",
            JMsgBox::buttons b = JMsgBox::ok,
            JMsgBox::type t = JMsgBox::informational);
  ~JMsgBox();

   // setting bits
   JMsgBox &setMessage( const char *msg);

   // showing the box
   ulong openModally( BOOL sysModal = false);
   ulong open( JWindow *centre_over_me);
   ulong openOverPointer( BOOL sysModal = false);

   BOOL closing();
};

#endif
