/*
 * JMutex.hpp
 *
 * Mutex semaphore class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jmutex_h
#define _jmutex_h

#include "JLib.h"

class JMutexSem
{
   ulong hSem;
   JMutexSem( const JMutexSem &) {}

 public:
   // opens shared named sem if possible, else creates a fresh one
   JMutexSem( const char *name);
   // creates a non-shared, non-named mutex.
   JMutexSem();
  ~JMutexSem();

   void request( ulong timeout = (ulong)-1) const;
   void release() const;

   class lock {
      const JMutexSem &m;

    public:
      lock( const JMutexSem *s) : m( *s) { m.request(); }
      lock( const JMutexSem &s) : m( s)  { m.request(); }
     ~lock()                             { m.release(); }
   };
};

#endif
