/*
 * JNPipes.hpp
 *
 * Named-pipe stream classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jnpipes_h
#define _jnpipes_h

#include "JLib.h"
#include "JBNPipe.hpp"
#include "JStream.hpp"
#include "JStrCli.hpp"

// client end of the pipe ----------------------------------------------------
class JRNamedPipe : public JRStream, public JPipeClient
{
 public:
   JRNamedPipe( const char *name, ulong timeout = HBAD, const char *servername = 0);
};

class JWNamedPipe : public JWStream, public JPipeClient
{
 public:
   JWNamedPipe( const char *name, ulong timeout = HBAD, const char *servername = 0);
};

class JRWNamedPipe : public JRStream, public JWStream, public JPipeClient
{
 public:
   JRWNamedPipe( const char *name, ulong timeout = HBAD, const char *servername = 0);
};

// server end -----------------------------------------------------------------
class JRPipeServer : public JPipeServer, public JRStream
{
 public:
   JRPipeServer( const char *name, ulong cbInBuffer, ulong cbOutBuffer,
                 uchar instances = (uchar)-1, ulong msWait = 0, BOOL isBytePipe = 1,
                 BOOL openAsByte = true, BOOL blocking = true);
};

class JWPipeServer : public JPipeServer, public JWStream
{
 public:
   JWPipeServer( const char *name, ulong cbInBuffer, ulong cbOutBuffer,
                 uchar instances = (uchar)-1, ulong msWait = 0, BOOL isBytePipe = 1,
                 BOOL openAsByte = true, BOOL blocking = true);
};

class JRWPipeServer : public JPipeServer, public JRStream, public JWStream
{
 public:
   JRWPipeServer( const char *name, ulong cbInBuffer, ulong cbOutBuffer,
                 uchar instances = (uchar)-1, ulong msWait = 0, BOOL isBytePipe = 1,
                 BOOL openAsByte = true, BOOL blocking = true);
};

#endif
