/*
 * JOpenDlg.hpp
 *
 * The open file dialog. Ought to use dragndrop, but hey...
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

// To do: EA stuff

// Note how this class is meant to be used: create an instance with new and
// do NOT delete it...

// Note you can get a `normal' saveas dialog with this too...

#ifndef _jopendlg_h
#define _jopendlg_h

#include "JLib.h"
#include "JStr.hpp"
#include "JBuffer.hpp"
#include "JSeq.hpp"
#include "JThread.hpp"

#include "JMWindow.hpp"

class JOpenDlgData;
class JOpenDlgClient;

class JOpenDlg : public JThread, public JMWindow
{
   JOpenDlgData *data;

   ulong operator () ();

  ~JOpenDlg();

 public:

   static const ulong
      normal,
      helpButton,
      multiSelect;

   // use 'new' amd don't delete it
   JOpenDlg( JWindow *owner, const char *initialname = "*.*",
             ulong style = normal, const char *filetype = 0,
             const char *title = "Open", const char *okbutton = "OK");

   // apparently some people don't like JSaveDlg.
   void makeSaveDialog();

   BOOL preHandleEvents( JEventData *e);

   // note that once a run method has returned, you must NOT re-run the
   // same dialog. Create another and start again.

   // call to just get the name of the file
   JStr run( BOOL *pressedCancel);

   // call to let JLib take the strain & call you back when it's loaded
   // all the selected files. Return code is false if dlg is cancelled.
   BOOL run( JOpenDlgClient *client, ulong id = 0);
};

// client gets passed a list of these.
struct JOpenDlgFile
{
   JStr    fname;
   JBuffer data;
   JOpenDlgFile( const JStr &n, const JBuffer &d);
   JOpenDlgFile( const JOpenDlgFile &f);
};

// derive classes from here to receive asynchronous wibble
class JOpenDlgClient
{
 public:

   // called when a file or set of files has been loaded
   virtual void openedFiles( JSequence<JOpenDlgFile> &list, ulong id) = 0;

   // called when a file-system error occurs; it has already been reported.
   virtual void openingError( ulong id) = 0;
};

#endif
