/*
 * JOwnerDH.hpp
 *
 * Owner-draw events and handler classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jownerd_h
#define _jownerd_h

#include "JLib.h"
#include "JCoord.hpp"
#include "JEvent.hpp"
#include "JHandler.hpp"

class JBPSpace;

/*
 * The window to which these events are sent, and hence should have handlers
 * attached them, depends on whether the control has been adopt'ed by its
 * owner. If so, the events will be dispatched to the control, which should
 * therefore have the handler attached to it. Otherwise, attach the handler to
 * the control's owner.
 *
 */

// Measure-item event, sent when PM needs to know the thing's size
class JMeasureEvent : public JEvent
{
 public:
   JMeasureEvent( JEventData *e) : JEvent( e) {}

   ushort controlId() const { return e->mp1.s1(); }
};

// Drawitem event; sent when the thing needs to be drawn
class JDrawItemEvent : public JEvent
{
   void *p;

 public:
   JDrawItemEvent( JEventData *e) : JEvent( e) { p = e->mp2(); }

   ushort   controlID() const { return e->mp1.s1(); }
   JBPSpace ps() const;
   long     itemID() const;
   ulong    itemHandle() const;
   JRect    itemRect() const;
   ulong   &oldState() const;
   ulong   &state() const;
};

// Handler; attach to the owner of a control which is custom (CustLBox/Cnr)
//          or to the control itself if it's been adopted
class JOwnerDrawHandler : public JHandler
{
   ulong ctlId;

 public:
   JOwnerDrawHandler( ulong controlId = (ulong)-1) : JHandler() { ctlId = controlId; }
   BOOL handle( JEventData *e);

   virtual BOOL measureItem( const JMeasureEvent &) { return false; }
   virtual BOOL drawItem( const JDrawItemEvent &)   { return false; }
};

#endif
