/*
 * JPM.hpp
 *
 * Definition for simple PM class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jpm_h
#define _jpm_h

#include "JLib.h"
#include "JExcept.hpp"

class JPM
{
   ulong _hab;
   ulong _hmq;

  public:
   JPM();
   virtual ~JPM();
   void process() const;

   ulong hab() const { return _hab; }
   ulong hmq() const { return _hmq; }

   // thread exception data.  Exceptions are stored here when generated
   JException *exn;
   JExnType    type;

   // call to shut down the message q
   JPM &quit();

   // override to override the message loop ending.
   // the default returns false, which will end the loop when a wm_quit is
   // detected which has been sent to the QUEUE.
   virtual BOOL quitting() const { return false; }

   // get the current JPM (one per thread)
   static JPM *current();
};

#endif
