/*
 * JPaintH.hpp
 *
 * Generic paint event and handler
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jptevent_h
#define _jptevent_h

#include "JLib.h"
#include "JEvent.hpp"
#include "JHandler.hpp"
#include "JCoord.hpp"
#include "JPSpace.hpp"

class JPaintEvent : public JEvent
{
   JBPSpace *_ps;
   JRect     update; // from beginpaint
   BOOL      needToZap;

 public:
   JPaintEvent( JEventData *e);

   void begin( JBPSpace *ready_made = 0);
   void end();

   JBPSpace &ps()                        { return *_ps; }
   JRect    &updateRect()                { return update; }
};

class JPaintHandler : public JHandler
{
   BOOL      avto;
   JBPSpace *cachedPS;

 public:
   // if this flag is set, begin/end will be called for you.
   JPaintHandler( BOOL avto = true);
   BOOL handle( JEventData *e);

   // to use a PS of your own, call this method
   JPaintHandler &setPS( JBPSpace *cache_me);

   virtual BOOL paint( JPaintEvent &) { return false; }
};

#endif
