/*
 * JPointer.hpp
 *
 * Pointer class - things to do with the mouse
 *                 ( a Pointer is the thing you see when you move the mouse)
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 */

#ifndef _jmouse_h
#define _jmouse_h

#include "JLib.h"

// note that there is JIcon.hpp to represent icons & pointers
class JPoint;
class JIcon;

// this class is really a thin veneer over the pointer APIs
// it doesn't make much sense to go around constructing objects of this class
class JPointer
{
 public:
    // pointer position
    static JPoint pos();
    static void   moveto( const JPoint &to);

    // pointer visibility
    static void show( BOOL doit = true);
    static void hide();

    // current pointer
    static void  set( JIcon &icon);
    static JIcon current();
};

#endif
