/*
 * JPosnH.hpp
 *
 * Window position change notifications
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jposnh_h
#define _jposnh_h

#include "JLib.h"
#include "JSWP.hpp"
#include "JEvent.hpp"
#include "JHandler.hpp"

class JPrePositionEvent : public JEvent
{
 public:
   JPrePositionEvent( JEventData *e) : JEvent( e) {}

   JSWP *getPosition() { return (JSWP*) e->mp1(); }

   void  setFlAwp( ulong u) { e->rc = u; }
};

class JPostPositionEvent : public JEvent
{
 public:
   JPostPositionEvent( JEventData *e) : JEvent( e) {}

   ulong flAwps() const { return e->mp2; }

   JSWP *getOldSWP() { return getNewSWP() + 1; }
   JSWP *getNewSWP() { return (JSWP *) e->mp1(); }
};

// Handler
class JPositionHandler : public JHandler
{
 public:
   JPositionHandler() : JHandler() {}
   BOOL handle( JEventData *e);

   // called just before a reposition is about to happen.  You may adjust
   // the contents of the SWP if necessary, & if you understand AWP_ flags,
   // feel free to set them
   virtual BOOL preReposition( JPrePositionEvent &) { return false; }

   // called after the window's position has been changed.
   // flAwps passed through from aboutToSize.
   // note the old SWP contains flags that correspond to what happened.
   virtual BOOL postReposition( JPostPositionEvent &) { return false; }
};

#endif
