/*
 * JProfile.hpp
 *
 * Profile - INI files
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jprofile_h
#define _jprofile_h

#include "JLib.h"
#include "JStr.hpp"
#include "JBuffer.hpp"

class JProfile
{
   JStr  name;
   JStr  lastapp;
   ulong hIni;
   void  check( const char **fish);

 public:
   JProfile( const char *name);
   JProfile( ulong hIni);
  ~JProfile();

   JProfile &write( const char *text, const char *key, const char *app = 0);
   JProfile &write( long number, const char *key, const char *app = 0);
   JProfile &write( const JVBuffer &buff, const char *key, const char *app = 0);

   JStr      readString( const char *key, const char *app = 0);
   long      readLong( const char *key, const char *app = 0);
   JProfile &read( JVBuffer &buff, const char *key, const char *app = 0);

   JProfile &emptyApp( const char *app = 0);

   static JProfile systemINI;
   static JProfile userINI;
};

#endif
