/*
 * JPushBut.hpp
 *
 * Base pushbutton control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jpushbut_h
#define _jpushbut_h

#include "JLib.h"
#include "JButton.hpp"
#include "JCoord.hpp"

class JWindow;

class JPushButton : public JButton
{
 public:
   // style
   static const unsigned long
      defButton,
      help,
      normal,
      syscommand;

   JPushButton( ulong hwnd) : JButton( hwnd) {}
   JPushButton( JWindow *parent, ulong id) : JButton( parent, id) {}
   JPushButton( JWindow *parent, const JPoint &pos, const JSize &size,
                ulong id, ulong style = JPushButton::normal,
                const char *text = "");

   // default ( I wish 'default' wasn't a reserved symbol! )
   JPushButton &setDefault( BOOL set = true);
   BOOL         isDefault() const;

   // hilight state
   JPushButton &setHilight( BOOL on = true);
   BOOL         hasHilight() const;
};

#endif
