/*
 * JSafeHT.hpp
 *
 * Threadsafe hashtable
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jshtable_h
#define _jshtable_h

#include "JLib.h"
#include "JHashTbl.hpp"
#include "JMutex.hpp"

// This collection is threadsafe in that accesses to the table are serialised.
// There's nothing to stop one thread altering the table while another is
// using a cursor; the user needs to manage this.  Although I'm considering
// putting cursor-tracking into the collections.

// Don't use unless you need to; strange errors to do with invalid hmuxen
// seem to happen when lots of mutices get taken out.

template<class T, class K>
class JSafeHTable : public JHashtable<T,K>, public JMutexSem
{
   typedef JHashtable<T,K> super;

 public:
   JSafeHTable( int sz = 23) : super( sz), JMutexSem() {}

   JSafeHTable<T,K> &put( const K &k, const T &t) {
      lock lk( this);
      super::put( k, t);
      return self;
   }

   T *get( const K &k) {
      lock lk( this);
      return super::get( k);
   }

   const T *get( const K &k) const {
      lock lk( this);
      return super::get( k);
   }

   BOOL contains( const K &k) const {
      lock lk( this);
      return super::contains( k);
   }

   void remove( const K &k) {
      lock lk( this);
      super::remove( k);
   }

   void empty() {
      lock lk( this);
      super::empty();
   }

   int elements() const {
      lock lk( this);
      return super::elements();
   }
};

#endif
