/*
 * JSaveDlg.hpp
 *
 * The save file dialog, design lifted from riscos.
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jfiledlg_h
#define _jfiledlg_h

#include "JLib.h"
#include "JDialog.hpp"

#include "JStr.hpp"
#include "JBuffer.hpp"
#include "JThread.hpp"
#include "JResID.hpp"

class JSaveDlgData;
class JSaveDlgClient;
class JPushedFileItem;

// Note: you should create objects of this class using new - don't worry
// about delete'ing them later.
// You can set the help ID using setHelpID, whose page will be displayed when
// the user presses f1.
class JSaveDlg : public JDialog, public JThread
{
   JSaveDlgData *data;
   void die( BOOL isCancel);

   ulong operator () ();

  ~JSaveDlg();

 public:
   // ctor - use new.
   // pass in a JStr which will be updated with the filename
   JSaveDlg( JWindow *owner, JVBuffer *buff, JStr &filename,
             const JResID &iconID = JResID(), const char *ftype = 0);

   // passed in closed events
   enum result {
      success,
      cancel
   };

   // returns immediately, runs asynchronously & amodally
   void run( JSaveDlgClient *c, ulong id = 0);
   // returns false if cancel was pressed. Runs asynchronously.
   BOOL runModally( JSaveDlgClient *c, ulong id = 0);
   // Both callback to the client - if supplied - in a second thread on
   // completion and before writing the buffer.

   BOOL preHandleEvents( JEventData *e);

   // overrides & extras
   BOOL closing();
   BOOL command( const JCmdEvent &c);
   BOOL doSave( const char *path);
   JPushedFileItem *beginDrag();
};

class JSaveDlgClient
{
 public:
   // return true to say 'yes, I've saved it - don't bother doing it'
   virtual BOOL savingImminent( JVBuffer *b, const JStr &nm, ulong id) = 0;
   // notification of dialog quitting
   virtual void savingComplete( JVBuffer *b, ulong id, BOOL cancelled) = 0;
};

#endif
