/*
 * JScrllbar.hpp
 *
 * Scrollbar control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jscroll_h
#define _jscroll_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"

class JCtlEvent;
class JWindow;

class JScrollbar : public JControl
{
 public:
   static const ulong
      vertical,
      horizontal,
      dynamic;

   JScrollbar( ulong h) : JControl( h) {}
   JScrollbar( JWindow *w, ulong id) : JControl( w, id) {}
   JScrollbar( JWindow *w, const JPoint &pos, const JSize &size, ulong id,
               ulong style);

   JScrollbar &setRange( const JRange &range, short slider_pos = 0);
   JScrollbar &setSliderSize( short total_data, short visible_data);
   JScrollbar &moveSliderTo( short new_position);
   JScrollbar &incrementSlider();
   JScrollbar &decrementSlider();

   JRange      range() const;
   short       position() const;

   virtual BOOL event( const JCtlEvent &) { return false; }
};

#endif
