/*
 * JScrollH.hpp
 *
 * Scroll events handler and event
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jscrollh_h
#define _jscrollh_h

#include "JLib.h"
#include "JEvent.hpp"
#include "JHandler.hpp"

class JScrollEvent : public JEvent
{
 public:
   JScrollEvent( JEventData *e) : JEvent( e) {}
   short position() const { return e->mp2.s1(); }

   enum cmd {
      lineUp    = 1,
      lineDown  = 2,
      lineLeft  = 1,
      lineRight = 2,
      pageUp    = 3,
      pageDown  = 4,
      pageLeft  = 3,
      pageRight = 4
   };

   cmd command() const    { return (cmd) e->mp2.s2(); }
};

// Handler; attach to the owner of the scrollbar
class JScrollHandler : public JHandler
{
   ulong Id;
 public:
   JScrollHandler( ulong id) : JHandler(), Id( id) {}
   BOOL handle( JEventData *e);

   virtual BOOL lineScroll( const JScrollEvent &) { return false; }
   virtual BOOL pageScroll( const JScrollEvent &) { return false; }
   virtual BOOL tracking( const JScrollEvent &)   { return false; }
   virtual BOOL dragEnded( const JScrollEvent &)  { return false; }
};

#endif
