/*
 * JSelButt.hpp
 *
 * Selectable buttons - radios and checkboxes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jselbutt_h
#define _jselbutt_h

#include "JLib.h"
#include "JButton.hpp"
#include "JCoord.hpp"

class JWindow;

class JRadioButton : public JButton
{
 public:

   // style
   static const unsigned long
      noselect,
      normal,
      nofocus;

   JRadioButton( ulong h) : JButton( h) {}
   JRadioButton( JWindow *parent, ulong id) : JButton( parent, id) {}
   JRadioButton( JWindow *parent, const JPoint &pos, const JSize &size,
                 ulong id, ulong style = JRadioButton::normal,
                 const char *text = "");

   // select state
   JRadioButton &check( BOOL set = true);
   BOOL          isChecked() const;

   // returns 0based index of checked radio-b in group.
   int getChecked() const;
};

class JCheckBox : public JButton
{
 public:

   // style
   static const unsigned long
      noselect,
      normal,
      nofocus;

   JCheckBox( ulong h) : JButton( h) {}
   JCheckBox( JWindow *parent, ulong id) : JButton( parent, id) {}
   JCheckBox( JWindow *parent, const JPoint &pos, const JSize &size,
              ulong id, ulong style = JCheckBox::normal, const char *text = "");

   // select state
   JCheckBox &check( BOOL set = true);
   BOOL       isChecked() const;
};

#endif
