/*
 * JSet.hpp
 *
 * Set collection header file
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jset_h
#define _jset_h

#include "JLib.h"
#include "JColln.hpp"

// Basic set - no order, element equality bad -------------------------------
template < class T>
class JSet : public JCollection
{
 protected:
   // as a set, we don't allow two equal elements
   virtual int compare( void *e1, void *e2, BOOL t)
   {
      int s = (realElement( *((T*)e1)) == realElement( *((T*)e2)));
      if( s && t) { jlib_throw( new JDuplicateKey); return 0; }
      else return !s;
   }

   void deleteElement( void *element) { delete (T*) element; }

 public:
   void add( const T &element)
        { JCollection::add( new T( element)); }
   void remove( const T &element)
        { JCollection::remove( (void*) &element); }
   BOOL contains( const T &element) const
        { return !!JCollection::find( (void*) &element); }

   typedef JIterator<T> iterator;

   void doForAll( const iterator &iter)
        { JCollection::doForAll( (const JVIterator &) iter); }

   typedef JConstIterator<T> const_iterator;

   void doForAll( const const_iterator &iter)
        { JCollection::doForAll( (const JVIterator &) iter); }

   typedef JCursor<T> cursor;

   void removeAt( const cursor &cursor)
        { JCollection::removeAt( (const JVCursor &) cursor); }

  ~JSet() { empty(); }
};

// Sorted set - order defined, element equality bad -------------------------
template < class T>
class JSortedSet : public JSet<T>
{
   // duplicates still bad
   int compare( void *e1, void *e2, BOOL t)
   {
      T &t1 = *(T*)e1; T &t2 = *(T*)e2;
      int s = realCompare( realElement( t1), realElement( t2));
      if( !s && t) { jlib_throw( new JDuplicateKey); return 0; }
      else return s;
   }

 public:

   typedef JIterator<T> iterator;
   typedef JConstIterator<T> const_iterator;
   typedef JCursor<T> cursor;
};

// Keyed set - order defined, key equality bad ------------------------------
template < class T, class K>
class JKeySet : public JKeyCollection
{
 protected:
   // sort by key, still a bag
   int compare( void *e1, void *e2, BOOL t)
   {
      T &t1 = *(T*)e1; T &t2 = *(T*)e2;
      int s = realCompare( key( realElement( t1)), key( realElement( t2)));
      if( !s && t) { jlib_throw( new JDuplicateKey); return 0; }
      else return s;
   }

   int compareK( void *el, void *keyy)
   {
      T &t = *(T*)el; K &k = *(K*)keyy;
      return realCompare( k, key( realElement( t)));
   }

   void deleteElement( void *element) { delete (T*) element; }

 public:
   void add( const T &element)
        { JCollection::add( new T( element)); }
   void removeElementWithKey( const K &k)
        { JKeyCollection::removeK( (void*) &k); }
   void removeElementsWithKey( const K &k)
        { JKeyCollection::removeAllK( (void*) &k); }
   BOOL containsElementWithKey( const K &k) const
        { return !!JKeyCollection::findK((void*) &k); }
   T   *elementWithKey( const K &k)
        { return (T*)JKeyCollection::withK( (void*) &k); }
   const T *elementWithKey( const K &k) const
        { return (T*)JKeyCollection::withK( (void*) &k); }

   typedef JCursor<T> cursor;

   void removeAt( const cursor &cursor)
        { JCollection::removeAt( (const JVCursor &) cursor); }

   typedef JIterator<T> iterator;

   void doForAll( const iterator &iter)
        { JCollection::doForAll( (const JVIterator &) iter); }

   typedef JConstIterator<T> const_iterator;

   void doForAll( const const_iterator &iter)
        { JCollection::doForAll( (const JVIterator &) iter); }

  ~JKeySet() { empty(); }
};

#endif
