/*
 * JShared.hpp
 *
 * Shared memory class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

/* This class provides shared-memory objects. To place or access an object in
   shared memory, derive the class from JSharedMem. Objects must be created
   using 'new'; bad things will happen if you try to construct one on the stack.
   Note that 'new' is overloaded and takes an extra argument of the name of the
   block, eg:

      SharedClass *sharedObject = new( "MYOBJ") SharedClass;

   Be wary of constructing over already established data, and of pointer
   objects in sharedmemory, especially JStrs won't work.
*/

#ifndef _jsharemem_h
#define _jsharemem_h

#include "JLib.h"

#include <stddef.h>

class JSharedMem
{
 protected:
   virtual ~JSharedMem() {}

 public:
   JSharedMem() {}
   void *operator new( size_t s, const char *name);
   void  operator delete( void *addr);

   static BOOL exists( const char *name);
};

#endif
