/*
 * JSpinBut.hpp
 *
 * Spinbutton control classes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jspinb_h
#define _jspinb_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"
#include "JStr.hpp"
#include "JSeq.hpp"

class JWindow;
class JCtlEvent;

// base spinbutton - captures the essential 'spinningness' of the control ----
class JSpinButton : public JControl
{
 public:
   // style
   static const ulong
      allowNumbers,
      readOnly,
      alignLeft,
      alignRight,
      alignMiddle,
      noBorder,
      fastSpin;

   // constructors
   JSpinButton( ulong hwnd) : JControl( hwnd) {}
   JSpinButton( JWindow *parent, ulong id) : JControl( parent, id) {}
   JSpinButton( JWindow *parent, const JPoint &pos, const JSize &size,
                ulong id, ulong style);

   // control of spinbutton
   JSpinButton &spinUp( ulong howfar = 1);
   JSpinButton &spinDown( ulong howfar = 1);

   JSpinButton &setTextLimit( uchar sze);

   JSpinButton &setMaster( JSpinButton *s);

   // event handling
   BOOL event( const JCtlEvent &e);
   virtual BOOL spanUp( ulong /*param*/)     { return false; }
   virtual BOOL spanDown( ulong /*param*/)   { return false; }
   virtual BOOL lostFocus()                  { return false; }
   virtual BOOL gainedFocus()                { return false; }
   virtual BOOL spinEnded()                  { return false; }
   virtual BOOL changed()                    { return false; }
};


// a numeric spinbutton, which spins thru a range of contiguous integers -----
class JNumericSpinButton : public JSpinButton
{
 public:
   // style
   static const ulong
      padWithZeros,
      normal;

   // constructors as expected, plus an extra one to create a servant spbn.
   JNumericSpinButton( ulong hwnd) : JSpinButton( hwnd) {}
   JNumericSpinButton( JWindow *w, ulong id) : JSpinButton( w, id) {}
   JNumericSpinButton( JWindow *parent, const JPoint &pos, const JSize &s,
                       ulong id, ulong style = JNumericSpinButton::normal);
   JNumericSpinButton( JWindow *parent, JSpinButton *master, const JPoint &pos,
                       const JSize &s, ulong id,
                       ulong style = JNumericSpinButton::normal);

   // set the range of the button. The flag is to do with whether the current
   // value is changed if it's now invalid.
   JNumericSpinButton &setRange( const JRange &r, BOOL updateField = true);
   JRange              range() const;

   // set/get the contents of the button. Dunno what asText() & set(...) do...
   JNumericSpinButton &setValue( long value);
   long                value() const;
};


// a text spinbutton, which spins thru an array of strings -------------------
class JTextSpinButton : public JSpinButton
{
 public:
   // style
   static const ulong
      allowAll,
      normal;

   // constructors...
   JTextSpinButton( ulong hwnd) : JSpinButton( hwnd) {}
   JTextSpinButton( JWindow *w, ulong id) : JSpinButton( w, id) {}
   JTextSpinButton( JWindow *parent, const JPoint &pos, const JSize &s,
                    ulong id, ulong style = JTextSpinButton::normal);
   JTextSpinButton( JWindow *parent, JSpinButton *master, const JPoint &pos,
                    const JSize &s, ulong id,
                    ulong style = JTextSpinButton::normal);

   // set the spin array
   // Because the spinbutton uses array indices to refer to its contents,
   // it makes sense to use a JArray collection here. Or a char **, iyp...
   // make sure to use append if you need to rely on the index values...
   JTextSpinButton &setRange( const JSequence<JStr> &array);
   JTextSpinButton &setRange( const char **array, ulong count);

   // set/get the contents of the button.
   ulong            valueIndex() const;
   JStr             value() const;
   JTextSpinButton &setValueIndex( ulong ndex);
};

#endif
