/*
 * JSplit.hpp
 *
 * Split window control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#include "JLib.h"
#include "JCoord.hpp"
#include "JControl.hpp"

class JWindow;

// A splitwindow has up to two children.  If both are present, a draggable
// separator is displayed to alter the proportion of the display each gets.
// The default orientation is left-right, but can be changed to up-down.
//
// The splitwindow sizes its children to fit
// 
// If the fixedSeparator style is set, the separator cannot be moved 
//
// If the noDeleteChildren style is set, any child windows will be reparented
// just before the splitwindow dies
//
// Instances can be included in dialog templates using the WC_SPLIT classname
// from <JLib.h>
//
class JSplitWindow : public JControl
{
 public:

   static const ulong
      normal,
      fixedSeparator,
      noDeleteChildren;

   JSplitWindow( ulong hwnd) : JControl( hwnd) {}
   JSplitWindow( JWindow *w, ulong id) : JControl( w, id) {}
   JSplitWindow( JWindow *parent, const JPoint &pos, const JPoint &size,
                 ulong id, ulong style = normal);

  ~JSplitWindow();

   // set the split windows
   JSplitWindow &setLeftWindow( JWindow *w);
   JSplitWindow &setRightWindow( JWindow *w);

   // set the orientation
   enum orientation {
      leftRight,
      updown
   };

   JSplitWindow &setOrientation( orientation o);

   // set the position of the separator, percentage
   JSplitWindow &setSplitPercentage( ushort pc);

   // notifications
   BOOL event( const JCtlEvent &e);

   // called after the user moves the separator
   virtual BOOL separatorChanged( ushort /*newPercent*/) { return false; }
};
