/*
 * JStaticG.hpp
 *
 * Static graphics controls - bitmaps & icons
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jstaticg_h
#define _jstaticg_h

#include "JLib.h"
#include "JControl.hpp"
#include "JBitmap.hpp"
#include "JIcon.hpp"
#include "JCoord.hpp"

class JCtlEvent;
class JWindow;

class JStaticBitmap : public JControl
{
 public:
   JStaticBitmap( JWindow *parent, ulong id) : JControl( parent, id) {}
   JStaticBitmap( ulong hwnd) : JControl( hwnd) {}
   JStaticBitmap( JWindow *parent, const JPoint &position,
                  const JSize &size, ulong id, ulong resId);

   virtual BOOL event( const JCtlEvent &) { return false; }

   JStaticBitmap &setImage( const JBitmap &nu);
   JBitmap        getImage();
};

class JStaticIcon : public JControl
{
 public:
   JStaticIcon( JWindow *parent, ulong id) : JControl( parent, id) {}
   JStaticIcon( ulong hwnd) : JControl( hwnd) {}
   JStaticIcon( JWindow *parent, const JPoint &position,
                const JSize &size, ulong id, ulong resId);

   virtual BOOL event( const JCtlEvent &) { return false; }

   JStaticIcon &setImage( const JIcon &nu);
   JIcon        getImage();
};

#endif
