/*
 * JStaticT.hpp
 *
 * Static text control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jstatt_h
#define _jstatt_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"

class JWindow;
class JCtlEvent;

class JStaticText : public JControl
{
 public:
   JStaticText( JWindow *parent, ulong id) : JControl( parent, id) {}
   JStaticText( ulong hwnd) : JControl( hwnd) {}

   static const unsigned long
      left,
      center,
      right,
      top,
      vcenter,
      bottom,
      normal,
      wordWrap;

   JStaticText( JWindow *parent, const JPoint &position,
                const JSize &size, ulong id,
                ulong style = JStaticText::normal,
                const char *text = "");

   virtual BOOL event( const JCtlEvent &) { return false; }
};

#endif
