/*
 * JStrCli.hpp
 *
 * Class which contains common behaviour between files & client n-pipes
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jstrcli_h
#define _jstrcli_h

#include "JLib.h"
#include "JStream.hpp"

// for all that, all this class really has is DosOpen, which, you've gotta
// admit, is not a very friendly api...

// thrown when you try to open a file & can't 'cos some so-and-so's locked it.
struct JSharingViolation : public JException
{
   JSharingViolation();
};

class JClientStream : public virtual JStream
{
 protected:
   JClientStream( const char *name, BOOL failIfNew, BOOL appendIfOld,
                  BOOL isRead, BOOL isWrite,
                  JStream::sharing = JStream::denyNone);
   JClientStream() : JStream( HBAD) {}
   void open( const char *name, BOOL failIfNew, BOOL appendIfOld,
              BOOL isRead, BOOL isWrite,
              JStream::sharing = JStream::denyNone);
 public:
   virtual ~JClientStream() {}
};

#endif
