/*
 * JSwp.hpp
 *
 * SWP wrapper and 'array-of-swps' class
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jswp_h
#define _jswp_h

#include "JLib.h"
#include "JCoord.hpp"
#include "JSeq.hpp"

struct _SWP;
class JWindow;

// It'd be nice to reference-count this cos it's so big, but it needs to be
// binary-compatible with the PM swp structure for efficiency. It's not used
// too much either, I suppose.
class JSWP
{
   ulong fl;
   long  cy, cx;     // Check out this ridiculous ordering fiasco :-(
   long  _y,_x;
   ulong behind;
   ulong hWnd;
   ulong d1, d2;

 public:
   JSWP( JWindow *insertBehind);
   JSWP( const JPoint &moveTo);
   JSWP( const JSize &sizeTo);
   JSWP( const JRect &shapeTo);
   JSWP( const JPoint &moveTo, const JSize &sizeTo);
   JSWP( ulong flags);
   JSWP();

   // flags
   static const ulong
      activate,
      deactivate,
      hide,
      maximize,
      minimize,
      move,
      restore,
      show,
      resize,
      zorder;

   // members
   const JPoint pos()  const       { return JPoint( _x, _y); }
   const JSize  size() const       { return JSize( cx, cy); }
   const JRect  rect() const       { return JRect( pos(), size()); }
   const ulong  hwnd() const       { return hWnd; }
   const ulong  hwndBehind() const { return behind; }
   const ulong  flags() const      { return fl; }

   long  &x()          { return _x; }
   long  &y()          { return _y; }
   long  &width()      { return cx; }
   long  &height()     { return cy; }
   ulong &hwnd()       { return hWnd; }
   ulong &hwndBehind() { return behind; }
   ulong &flags()      { return fl; }

   // PM stuff
   operator _SWP * () const;
   operator _SWP & () const;
};

// used in the frame-controls bits
class JSWPArray : public JSequence<JSWP *>
{
 public:
   JSWPArray( JSWP *p, int count);
   int indexOf( ushort id); // find index of swp whose window has id...
};

#endif
