/*
 * JSystem.hpp
 *
 * Interface to system-y things
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jsys_h
#define _jsys_h

#include "JLib.h"
#include "JCoord.hpp"
#include "JKeyH.hpp"

class JBitmap;

class JSystem
{
 public:

   enum value {
      sizeborderWidth  = 4,
      sizeborderHeight,
      deskWidth = 20,
      deskHeight,
      scrollWidth,
      scrollHeight,
      dlgborderWidth = 28,
      dlgborderHeight,
      titlebarHeight,
      minmaxWidth      = 33,
      minmaxHeight,
      menuHeight,
      iconWidth        = 38,
      iconHeight,
      pointerWidth,
      pointerHeight
   };

   static JBitmap capture( const JRect &area = JRect());

   // sysvalues
   static ulong query( value);

   // pm lockup
   static void lockup();
   static BOOL unlock( const char *password);

   static JSize &screen();

   // sounds
   static void beep( ulong pitch, ulong duration);

   enum alarm_type {
      warning,
      note,
      error
   };

   static void alarm( alarm_type t);

   // keyboard
   static BOOL isToggled( JKeyEvent::vkeys);
   static BOOL isDown( JKeyEvent::vkeys);

   // os version
   static ulong getMinorOSVersion();
   static ulong getMajorOSVersion();
   static BOOL  isWarp4();

   // default fonts from os2.ini
   static JStr getGeneralFont();
   static JStr getTitlebarFont();
   static JStr getMenuFont();
   static JStr getIconFont(); // for (eg) container objects
};

#endif
