/*
 * JViewer.hpp
 *
 * Sizing window
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jscanv_h
#define _jscanv_h

#include "JLib.h"
#include "JControl.hpp"
#include "JCoord.hpp"

class JViewerData;
class JCtlEvent;

class JViewer : public JControl
{
   JViewerData  *data;
   void          adjustSize( const JSize &s, BOOL first = false, long exHeight = 0);
   void          scrollWindow( long dx, long dy);
   JPoint        orig() const;
   friend class  JViewerSizeH;
   friend class  JViewerVScrollH;
   friend class  JViewerKeyH;
   friend class  JViewerHScrollH;
   void setup( JWindow *w, JWindow *v, const JPoint &p, const JSize &s,
               ulong i, ulong st);
 public:

   // style: normal = dynamic + destroyViewee
   static const ulong
      normal,
      dynamic,
      destroyViewee;

   // create a new view window, with 'viewee' as the viewee.
   // If you don't set the destroyViewee flag, the viewee window will be
   // reparented just before the viewer dies.
   JViewer( JWindow *parent, JWindow *viewee, const JPoint &pos,
            const JSize &size, ulong id, ulong style = JViewer::normal);
   // used to take an existing control's area, after deleting it
   JViewer( JWindow *parent, ulong id, JWindow *viewee,
            ulong style = JViewer::normal);
  ~JViewer();

   // get a vector from the tlhc of the viewee to the tlhc of the view
   JPoint   offset() const;
   // get the visible rect, relative to the viewee.
   JRect    view() const;
   // scroll to here, in viewee window coords
   JViewer &scrollTo( const JPoint &p);

   // get/set size of viewee; updates viewer accordingly (scrollbars etc.)
   // the maximum size a viewer can be is the size of its viewee
   JSize   &getVieweeSize() const;

   // when you make the viewee larger, the invariant maintained is the
   // position of the left-hand corner relative to the viewer.  This is a bit
   // odd, with PM having its origins at the bottom-left, but documents tend
   // to grow down, and so if you do your painting & drawing relative to the
   // top, things will work nicely.
   //
   // Be careful - attempting to size the viewee smaller than the viewer
   // is a logical error, and will be flagged (action will not be performed)
   JViewer &setVieweeSize( const JSize &p);

   // get the viewee window
   JWindow *viewee() const;

   BOOL event( const JCtlEvent &) { return false; }
};

#endif
