/*
 * JWrap.hpp
 *
 * A word-wrapped static text control
 * _________________________________________________________________________
 *
 *                     Part of JLib - John Fairhurst
 * _________________________________________________________________________
 *
 *
 */

#ifndef _jwrap_h
#define _jwrap_h

#include "JLib.h"
#include "JControl.hpp"
#include "JStr.hpp"

// Why does this exist when there's SS_STATICTEXT|DT_WORDBREAK ?
// Well, this class tells you how tall it needs to be to in a given width
// to display all the text.  It's very possible the static control does this
// too, using the SS_AUTOSIZE thingy, but I can neither find any documentation
// on that style nor get it to work.

class JCtlEvent;
class JBPSpace;

class JWrapText : public JControl
{
   JStr  text;
   ulong ht;
   ulong wrap( JBPSpace &ps, const JRect &rcl, BOOL doit);
   void setup( JWindow *w, const JPoint &p, const JSize &z, ulong i, ulong s);
   friend class JWrapPaintHandler;

 public:
   // style
   static const ulong
      normal,
      centred,
      leftAligned;

   // ctors
   JWrapText( JWindow *parent, const JPoint &pos, const JSize &sz, ulong id,
              ulong style = JWrapText::normal);
   // steal the indicated control's space
   JWrapText( JWindow *parent, ulong id, ulong style = JWrapText::normal);

   // overrides
   JWrapText &setText( const char *txt);
   JStr       getText() const   { return text; }

   // how much vertical space does the text occupy?
   // if the parameter is zero, the window width is used.
   ulong height( ulong xSpace = 0);

   BOOL event( const JCtlEvent &) { return false; }
};

#endif
