#include "Test.hpp"       // get our classes

#include "Test.h"         // get our resource def's

#include "JPM.hpp"        // get jlib classes we use
#include "JExcept.hpp"
#include "JCnrRec.hpp"
#include "JDrgItem.hpp"
#include "JDragSet.hpp"
#include "JColour.hpp"
#include "JPSpace.hpp"
#include "JFont.hpp"
#include "JMsgBox.hpp"

#define INCL_WINWINDOWMGR
#include <os2.h>

void main()
{
   JException::debugEnabled = true;

   frame frm;

   frm.show().activate();

   JPM::current()->process();
}

// our container
ctr::ctr( JWindow *pa) : JContainer( pa, JPoint(), JPoint(), 0, JContainer::autoPosition),
                         icon( JResID( id_ico_coin))
{
   attach( &hp);
}

JDropOk ctr::isDropOk( JDragSet &set)
{
   JDropOk drp( JDrag::yes, JDrag::link);

   if( !set.willAllow( JDrag::link))
      drp.state = JDrag::no_location;

   if( !set.hasRenderingMech( JDrag::file))
      drp.state = JDrag::no_location;

   return drp;
}

void ctr::drop( JDragSet &set)
{
   ulong itms = set.items(), i;
   for( i = 0; i < itms; i++) {
      rec *rc = new( this) rec( icon, set[ i].targetName());
      insert( rc);
   }
}

JDrag::psr ctr::deleteRecord( JCnrRecord *re)
{
   rec *rc = (rec *) re;
   rc->remove( true);
   return JDrag::doneIt;
}

// the frame class
frame::frame() : JFrame( "A container"),
                 cnr( this),
                 icon( JResID( id_ico_coin)),
                 bgMenu( JResID( id_bg_menu), &JWindow::theDesktopWindow),
                 fgMenu( JResID( id_obj_menu), &JWindow::theDesktopWindow),
                 font( "System Proportional")
{
   showInTasklist();
   setClient( &cnr);
   cnr.addTitle( "Another title");
   adopt( &cnr);

   JCnrRecordList list;

   rec *rc = new(cnr) rec( icon, "File 1");
   list.append( rc);
   rc = new(cnr) rec( icon, "File 2");
   list.append( rc);

   cnr.insert( list);
   JCnrColumn *ic = new JCnrColumn( &cnr, JCnrRecord::iconOffset, JCnr::graphic, "Object");
   cnr.insert( ic);
   ic = new JCnrColumn( &cnr, JCnrRecord::textOffset, JCnr::string, "Name");
   cnr.insert( ic);

   cnr.setView( JCnr::icon);
   cnr.setContainerMenu( &bgMenu);
   cnr.setRecordMenu( &fgMenu);

// attach( &h);

   cnr.setCustomBackground();
}

BOOL frame::command( const JCmdEvent &e)
{
   switch( e.value()) {
      case idm_icon:
         cnr.setView( JCnr::icon);
         return true;
      case idm_details:
         cnr.setView( JCnr::detailsTitles);
         return true;
      case idm_text:
         cnr.setView( JCnr::text);
         return true;
      case idm_one:
      {
      // JStr *str = new JStr( "data");
      // JStr *fn = new JStr( "FileName");
      // JSaveDlg *d = new JSaveDlg( this, str, *fn);
         return true;
      }
      case idm_two:
         font = JFont::pickFont( this, "A font", &font);
         break;
      case idm_three:
      {
         JMsgBox mb( this, "This is a long message.  Oh yes.  I hope it will span several lines and size the dialog appropriately.  Oh yes.");
         mb.openModally();
         break;
      }
   }
   return false;
}

// record class ----
rec::rec( ulong a, char *b) : JCnrRecord( b, a), setts( 0)
{}

rec::~rec()
{ if( setts) delete setts; }

#include "jtrace.hpp"

JDragItem *rec::initDrag()
{
   JFileItem *itm = new JFileItem( core->txtIcon, THIS_PATH,
                                   core->hIcon);
   itm->setSupportedOps( JDrag::copyable);
   itm->supportDiscard();
   itm->supportPrint();

   trace << "Created a FileItem for " << core->txtIcon;

   return itm;
}

void rec::closeSettings()
{
   setts->hide();
   removeEmphasis( JCnr::open);
}

void rec::openSettings()
{
   if( !setts)
      setts = new Settings( cnr, this);
   setts->turnToTop();
   setts->setText( JVStr( "%s - Settings", text().buffer()));
   setts->show().activate();
}

BOOL rec::opened()
{
   openSettings();
   return false;
}

JDrag::psr rec::print( void *magic)
{
   return JDrag::youDoIt;
}

// cnr background handler ------
cnrpainter::cnrpainter() : JCnrPaintHandler()
{}

BOOL cnrpainter::paintBackground( JCnrPaintEvent &e)
{
   e.ps().fillRect( e.updateRect(), JColour::red);
   e.setrc( true);
   return true;
}

// settings dialog class
Settings::Settings( JWindow *owner, rec *r) : JDialog( owner, idd_settings),
                                              book( this, idc_notebook),
                                              rc( r)
{
   page1 = new JDialog( idd_page1, &book);
   book.addSection( page1, "Section 1", "Page 1 of 2");
   page2 = new JDialog( idd_page2, &book);
   book.addPage( page2, "Page 2 of 2");
   page3 = new JDialog( idd_page3, &book);
   book.addSection( page3, "Section 2");
}

Settings::~Settings()
{ delete page1; delete page2; delete page3; }

BOOL Settings::closing()
{ rc->closeSettings(); return JDialog::closing(); }

JWindow &Settings::turnToTop()
{
   book.turnToTop();
   return book;
}
