// Run-time trace & exception tracker app
// MJF 17th August 1996

#include "JDebug.hpp"   // window & handler definitions
#include "JDebug.h"     // resource definitions

#include "JPM.hpp"      // JLib classes we utilize here
#include "JCoord.hpp"
#include "JStr.hpp"
#include "JResID.hpp"
#include "JCmdH.hpp"
#include "JBuffer.hpp"
#include "JNPipes.hpp"

#include "JExcept.hpp"
#include <string.h>
#include "JDrgItem.hpp"
#include "JDragSet.hpp"

int main()
{
   debugWindow debug;

   debug.reshape( JPoint( 4, 460), JSize( 540, 300));
   debug.show();

   JPM::current()->process();

   return 0;
}

// the debugger. most of the work is done in the constructor.

debugWindow::debugWindow() : JFrame( "JLib monitor"),
                             mle( this, JPoint(), JPoint(), 0,
                                  JMLE::normal | JMLE::vertScroll | JMLE::readonly),
                             stopNow( 0),
                             thread( 0)
{
   // set up the client to be the mle
   setClient( &mle);

   // set the window furniture
   setMenu( JResID( idmenu_main));

   // set up the second thread.
   // create a semaphore so that we know when the thread's started
   thread = new readerThread( this, stopNow);
   thread->start();

   // finally, put us in the tasklist
   showInTasklist();
}

debugWindow::~debugWindow()
{
   // we need to shut down the reader thread; this is a bit iffy.
   // I suppose we could send it a message to wake it up!
   stopNow = true;
   thread->kill();
   delete thread;
}

// handler for wm_command events
BOOL debugWindow::command( const JCmdEvent &e)
{
   switch( e.value()) {
      case idm_clear:
         mle.empty();
         break;
      case idm_test:
      {
         JWNamedPipe pipe( "JLDEBUG");
         JBuffer buff( 1024);
         strcpy( (char *) buff.pvAddr(), "The monitor is working correctly!");
         pipe.write( buff);
         break;
      }
   }

   return true;
}

void debugWindow::incoming( char *str) // gets called when we get a msg
{
   mle.addLine( JVStr( "%s\n", str));
}

// pipe reader thread ---------------------------------------------------------
readerThread::readerThread( debugWindow *w, BOOL &stop)
             : JThread(), wnd( w), stopNow( stop)
{}

ulong readerThread::operator () ()
{
   // create the pipeserver object
   JRPipeServer pipe( "JLDEBUG", 1024 * 4, 1024 * 4, 1);

   JBuffer buff( 1024);
   JPM    *pm( JPM::current());

   do {
      // get a connection
      JPipeServer::connection client( pipe);

#ifdef REALLY_THROW_EXCEPTIONS
      try
#endif
      {
         for( ;;) {
            // wait for a message
            pipe.read( buff);
            if( stopNow
#ifndef REALLY_THROW_EXCEPTIONS
                        || pm->exn
#endif
                                  ) break;
            // show the message
            wnd->incoming( (char *) buff.pvAddr());
         }
      }

      // when the client app quits, we get an eof on the pipe
#ifdef REALLY_THROW_EXCEPTIONS
      catch ( JEOF *eof) {}
#else
      if( pm->exn) jlib_catch();
#endif
   } while( !stopNow);
   return 0;
}
