// Slammed together port of hard-coded 3 ball juggler - needs neatening up
// MJF 10th January 1997    NP - What's the story
#include "Test.hpp"
#include <math.h>
#include <JPM.hpp>
#include <JExcept.hpp>

#define PI 3.141592654

int main()
{
   JException::debugEnabled = true;

   JugglerFrame frame;

   frame.show().activate();

   JPM::current()->process();

   return 0;
}


// A juggling ball ------------------------------------------------------------
JugglingBall::JugglingBall( Juggler &j, JColour c, int i, int e)
             : juggler( j), col( c), enterOn( e), enterAt( i)
{
   if( enterOn == 0) index = enterAt;
   else index = -1;
}

void JugglingBall::move()
{
   if( index >= 0) {
      if( index == juggler.path().elements() - 1) index = 0;
      else index++;
   } else if( juggler.tickCount() == enterOn)
      index = enterAt;
}

void JugglingBall::paint( JBPSpace &ps)
{
   if( index >= 0) {
      ps.setColour( col).
         render( JMove( *(juggler.path()[ index]))).
         render( JCircle( juggler.radius(), true, true));
   }
}

// a hand which gets animated ------------------------------------------------
JugglerHand::JugglerHand( Juggler &j, const JPoint &p, int len, int steps, BOOL cw)
            : juggler( j), center( p), clockWise( cw), path( true), index( 0)
{
   for( double i = 0.0; i < (double) steps; i++) {
      double r = PI / 2.0 + 2.0 * PI *  i / (double) steps;
      path.append( JPoint( center.x + (int) ((double) len * sin( r)),
                           center.y + (int) ((double) len * cos( r))));
   }
}

void JugglerHand::move()
{
   if( clockWise) {
      if( index == path.elements() - 1) index = 0;
      else index++;
   } else {
      if( index == 0) index = path.elements() - 1;
      else index--;
   }
}

void JugglerHand::paint( JBPSpace &ps)
{
   ps.setColour( JColour::black)
     .render( JMove( center))
     .render( JLine( *(path[ index])));
}

JPoint JugglerHand::nth( int n)
{ return *(path[ n]); }

// The juggler object ---------------------------------------------------------
Juggler::Juggler() : JCanvas( &JWindow::theObjectWindow), buffer( dc),
                     _tickCount( 0), arcTime( 504.0), range( 100.0),
                     climb( 115.0), handl( 15), _path( true), rad( 10),
                     timer( new JugglingTimer( this)), img( Juggler::szScreen)

{
   buffer.select( img);

   tickTime = arcTime / 6.0;
   gravity = 8.0 * climb / ( arcTime * arcTime);

   JugglerHand *RH = new JugglerHand( *this, JPoint( 25, 45), handl, 6, false);
   JugglerHand *LH = new JugglerHand( *this, JPoint( 125, 45), handl, 6, true);
   hands.add( JPtr<JugglerHand>(RH));
   hands.add( JPtr<JugglerHand>(LH));

   JPoint rStart = RH->nth( 0);
   JPoint rEnd   = RH->nth( 3);
   JPoint lStart = LH->nth( 3);
   JPoint lEnd   = LH->nth( 0);
   JPoint primeA = pathEqn( tickTime);
   JPoint primeB = pathEqn( tickTime * 2.0);
   JPoint primeC = pathEqn( tickTime * 3.0);

   _path.append( JPoint( rStart));
   _path.append( JPoint( rStart + primeA));
   _path.append( JPoint( rStart + primeB));
   _path.append( JPoint( rStart + primeC));
   _path.append( JPoint( lEnd.x - primeB.x, lEnd.y + primeB.y));
   _path.append( JPoint( lEnd.x - primeA.x, lEnd.y + primeA.y));
   _path.append( JPoint( lEnd));
   _path.append( JPoint( LH->nth( 1)));
   _path.append( JPoint( LH->nth( 2)));
   _path.append( JPoint( lStart));
   _path.append( JPoint( lStart.x - primeA.x, lStart.y + primeA.y));
   _path.append( JPoint( lStart.x - primeB.x, lStart.y + primeB.y));
   _path.append( JPoint( lStart.x - primeC.x, lStart.y + primeC.y));
   _path.append( JPoint( rEnd + primeB));
   _path.append( JPoint( rEnd + primeA));
   _path.append( JPoint( rEnd));
   _path.append( JPoint( RH->nth( 2)));
   _path.append( JPoint( RH->nth( 1)));

   JugglingBall *a = new JugglingBall( *this, JColour::red, 0, 0);
   JugglingBall *b = new JugglingBall( *this, JColour::blue, 9, 2);
   JugglingBall *c = new JugglingBall( *this, JColour::green, 0, 5);
   balls.add( JPtr<JugglingBall>(a));
   balls.add( JPtr<JugglingBall>(b));
   balls.add( JPtr<JugglingBall>(c));

   JGSettings *s = new JGSettings;
   s->setFGColour( JColour::black);

   chain.append( JGPtr( s));
   chain.append( JGPtr( new JMove( 75, 10)));
   chain.append( JGPtr( new JLine( 75, 140)));
   chain.append( JGPtr( new JMove( 75, 120)));
   chain.append( JGPtr( new JLine( 125, 100)));
   chain.append( JGPtr( new JLine( 125, 45)));
   chain.append( JGPtr( new JMove( 75, 120)));
   chain.append( JGPtr( new JLine( 25, 100)));
   chain.append( JGPtr( new JLine( 25, 45)));
   chain.append( JGPtr( new JMove( 75, 160)));
   chain.append( JGPtr( new JCircle( 20)));

   startTimer( timer, (long) tickTime);
}

Juggler::~Juggler()
{
   buffer.deselectBitmap();
   stopTimer( timer);
   delete timer;
}

JPoint Juggler::pathEqn( double t)
{
   return JPoint( (int) ( range * t * sqrt( gravity / ( 8.0 * climb))),
                  (int) ( t * sqrt( 2.0 * climb * gravity) - 0.5 * gravity * t * t) );
}

PointArray &Juggler::path()
{ return _path; }

int Juggler::radius()
{ return rad; }

int Juggler::tickCount()
{ return _tickCount; }

BOOL Juggler::paint( JPaintEvent &e)
{
   e.ps().render( JBmpImage( buffer, e.updateRect(), e.updateRect()));
   return true;
}

void Juggler::timerTick()
{
   buffer.clear();
   buffer.render( chain);

   hands.doForAll( HandIterator( buffer));
   balls.doForAll( BallIterator( buffer));
   invalidate();
   if( _tickCount < 7) _tickCount++;
}

JSize Juggler::szScreen( 150, 200);

// Frame

JugglerFrame::JugglerFrame() : JFrame( "Three ball cascade")
{
   juggler.resize( Juggler::szScreen);
   sizer = new JViewer( this, &juggler , JPoint(), JSize(), 0);

   setClient( sizer);
   setMaxClientSize( Juggler::szScreen);
   sizeClientTo( Juggler::szScreen);
   showInTasklist();
   centreOver( &JWindow::theDesktopWindow);
}

JugglerFrame::~JugglerFrame()
{ delete sizer; }
