// Juggler test
// John Fairhurst 10th January 1997

#include <JLib.h>
#include <JCanvas.hpp>
#include <JDC.hpp>
#include <JPSpace.hpp>
#include <JGPrim.hpp>
#include <JGLPrim.hpp>
#include <JSeq.hpp>
#include <JBag.hpp>
#include <JColour.hpp>
#include <JWindow.hpp>
#include <JFrame.hpp>
#include <JViewer.hpp>
#include <JBitmap.hpp>

typedef JSequence<JPoint> PointArray;

class Juggler;

class JugglingBall
{
   JColour  col;
   int      index, enterAt;
   int      enterOn;
   Juggler &juggler;

 public:
   JugglingBall( Juggler &j, JColour col, int i, int e);
   void move();
   void paint( JBPSpace &ps);

   int operator == (const JugglingBall &op2) const { return this == &op2; }
};

class JugglerHand
{
   Juggler &juggler;
   JPoint   center;
   BOOL     clockWise;
   int      index;

   PointArray path;

 public:
   JugglerHand( Juggler &j, const JPoint &p, int len, int steps, BOOL cw);
   void move();
   void paint( JBPSpace &ps);
   JPoint nth( int n);

   int operator == (const JugglerHand &op2) const { return this == &op2; }
};

typedef JBag<JPtr<JugglingBall> > BallBag;
typedef JBag<JPtr<JugglerHand> >  HandBag;

class HandIterator : public HandBag::iterator
{
   JBPSpace &ps;

 public:
   HandIterator( JBPSpace &p) : ps( p) {}
   void action( JPtr<JugglerHand> &h)
   {
      h->move();
      h->paint( ps);
   }
};

class BallIterator : public BallBag::iterator
{
   JBPSpace &ps;

 public:
   BallIterator( JBPSpace &p) : ps( p) {}

   void action( JPtr< JugglingBall> &b)
   {
      b->move();
      b->paint( ps);
   }
};

class JugglingTimer;

class Juggler : public JCanvas
{
   JMemoryDC dc;
   JPSpace   buffer;
   JGList    chain;
   JBitmap   img;

   long     _tickCount;

   // path equation constants
   double arcTime;
   double range;
   double climb;
   double tickTime;
   double gravity;

   // figure bits
   HandBag hands;
   int     handl;

   // path point vectors

   PointArray _path;

   // balls
   BallBag balls;
   int     rad;

   JPoint pathEqn( double t);

   JugglingTimer *timer;

 public:

   static JSize szScreen;

   Juggler();
  ~Juggler();
   BOOL paint( JPaintEvent &e);

   PointArray &path();
   int         radius();
   int         tickCount();

   void        timerTick();
};

class JugglingTimer : public JWindowTimer
{
   Juggler *juggler;
 public:
   JugglingTimer( Juggler *j) : juggler( j) {}
   void operator() ( JWindow *w)
   {
      juggler->timerTick();
   }
};

// Wrapping window bollox -----------------------------------------------------
class JugglerFrame : public JFrame
{
   JViewer  *sizer;
   Juggler   juggler;
 public:
   JugglerFrame();
  ~JugglerFrame();
};
