/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * ColourBase.cpp - common classes to the colour subsystem
 *                  See doc/Colours
 *
 * Version history: 2/3/97  First Version
 *
 */

#include <JLib.h>
#include <JStr.hpp>
#include <JExcept.hpp>

#include "ColourBase.hpp"
#include "ResID.h"

// Colour model base class ----------------------------------------------------
ColourModel::ColourModel( JWindow *w, const JResID &r) : JDialog( w, r)
{}

ColourModel::~ColourModel()
{}

ColourModelProvider::ColourModelProvider()
{}

ColourModelProvider::~ColourModelProvider()
{}

int ColourModelProvider::operator == ( const ColourModelProvider &op2) const
{ return name() == op2.name(); }

BOOL ColourModel::closing()
{ dismiss( JDialog::idCancel); return true; }

// Shared gui components. May move into a seperate library sometime -----------

// Canvas showing a colour
ClrCanvas::ClrCanvas( ColourModel *d, const JColour &col)
          : JCanvas( d, id_canvas_clr), c( col)
{}

const JColour &ClrCanvas::colour() const
{ return c; }

JColour &ClrCanvas::colour()
{ return c; }

BOOL ClrCanvas::paint( JPaintEvent &e)
{
   e.ps().fillRect( e.updateRect(), c);
   return true;
}

// Notifying slider
NotifyingSlider::NotifyingSlider( ColourModel *c, ulong id)
                : JHorzSlider( c, id), cm( c)
{
   for( int i = 0; i < 256; i += 10)
      setTickLength( i, 10);
   for( i = 5; i < 256; i += 10)
      setTickLength( i, 5);
}

BOOL NotifyingSlider::changed()
{
   cm->notify( ID(), armPosInTicks());
   return true;
}

BOOL NotifyingSlider::tracking()
{
   cm->notify( ID(), armPosInTicks());
   return true;
}
