/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * ColourModels.cpp - colour selection models
 *                    See doc/Colours
 *
 * Version history: 2/3/97  First Version
 *
 */

#include <JLib.h>
#include <JStr.hpp>

#include "ColourModels.hpp"
#include "ResID.h"

// Naive RGB colour model... --------------------------------------------------
NRGBModel::NRGBModel( JWindow *p, const JColour &c)
           : ColourModel( p, dlg_colour_rgb),
             clr( this, c),
             slidR( this, id_slider_red),
             slidG( this, id_slider_green),
             slidB( this, id_slider_blue),
             textR( this, id_text_red),
             textG( this, id_text_green),
             textB( this, id_text_blue),
             border( this, id_border_clr)
{
   slidR.moveArmInTicks( c.cRed());
   slidG.moveArmInTicks( c.cGreen());
   slidB.moveArmInTicks( c.cBlue());
   textR.setText( JVStr( "%d", c.cRed()));
   textG.setText( JVStr( "%d", c.cGreen()));
   textB.setText( JVStr( "%d", c.cBlue()));
   adopt( &slidR);
   adopt( &slidG);
   adopt( &slidB);
   border.setType( JBorder::bevelIn);
}

NRGBModel::~NRGBModel()
{}

JColour NRGBModel::current() const
{ return clr.colour(); }

void NRGBModel::notify( ulong who, ulong what)
{
   switch( who) {
      case id_slider_red:
         clr.colour().cRed() = what;
         textR.setText( JVStr( "%d", what));
         break;
      case id_slider_green:
         clr.colour().cGreen() = what;
         textG.setText( JVStr( "%d", what));
         break;
      case id_slider_blue:
         clr.colour().cBlue() = what;
         textB.setText( JVStr( "%d", what));
         break;
   }
   clr.invalidate();
}

// ...and provider:
NRGBProvider::NRGBProvider()
{}

NRGBProvider::~NRGBProvider()
{}

ColourModel *NRGBProvider::create( JWindow *owner, const JColour &c)
{ return new NRGBModel( owner, c); }

ulong NRGBProvider::ID() const
{ return idm_pick_rgb; }

static JStr myname( "Simple RGB");

JStr &NRGBProvider::name() const
{ return myname; }
