/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * Main.cpp - kicks off the whole shebang
 *
 * Version history: 26/1/97  First Version
 *                  23/3/97  Added code to cope with multiple instances
 *
 */

#include <JLib.h>
#include <JPM.hpp>
#include <JBitmap.hpp>
#include <JSystem.hpp>
#include <JExcept.hpp>

#include "PaintMgr.hpp"

int main( int argc, char **argv)
{
   JException::debugEnabled = true;

   // Work out if we're the first instance of Paint
   BOOL madeHere = !JSharedMem::exists( MEM_NAME);

   PaintFootPrint *pfp = new( MEM_NAME) PaintFootPrint;

   if( madeHere) {
      // Yup, we're the original item - so let's get started
      pfp->hWnd = mgr.father()->handle();

      if( argc > 1)
         mgr.newPainting( argv[ 1]);
      else
         mgr.newPainting( JBitmap( JSystem::screen(), 8));

      JPM::current()->process();
   } else {
      // D'oh - we need to get the already-running instance to load the image
      if( argc > 1) {
         strcpy( pfp->filename, argv[ 1]);
         JWindow::PostEvent( pfp->hWnd, PWM_NEW);
      } else
         JWindow::PostEvent( pfp->hWnd, PWM_FOCUS);
   }

   delete pfp;

   return 0;
}
