/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * PaintMgr.cpp - A 'factory' class which looks after all paintings
 * and holds common resources, eg. the toolbox.
 *
 * Version history: 26/1/97  First Version
 *
 */

#pragma priority( 101)   // After pm

#include <JProfile.hpp>
#include <JMWindow.hpp>
#include <JWindow.hpp>
#include <JEvent.hpp>
#include <JPM.hpp>

#include "PaintMgr.hpp"

PaintManager::PaintManager() : _ini( 0), s( 0), patriarch( new PaintMgrWindow)
{
   // load settingsdata from ini
   settings.loadFromProfile( prf());
   s = new Settings;
}

PaintManager::~PaintManager()
{
   // clean up
   if( _ini) delete _ini;
}

void PaintManager::end()
{
   // save the settings
   settings.saveToProfile( prf());
   // delete the settings window if we have one
   if( s) delete s;
   // delete the patriarch if we got that far
   if( patriarch) delete patriarch;
   // quit the q
   JPM::current()->quit();
}

JWindow *PaintManager::father() const
{ return patriarch; }

Painting *PaintManager::newPainting( char *filename)
{
   Painting *p = new Painting( filename);
   paintings.add( p);
   p->show().activate();
   return p;
}

Painting *PaintManager::newPainting( const JBitmap &bmp)
{
   Painting *p = new Painting( bmp);
   paintings.add( p);
   p->show().activate();
   return p;
}

void PaintManager::closeMe( Painting *p)
{
   if( p->close()) {
      paintings.remove( p);
      delete p;
      if( 0 == paintings.elements())
         end();
   }
}

void PaintManager::closeAllWindows()
{
   Paintings::cursor c( paintings);
   Paintings         closeList;

   for_cursor( c) {
      if( false == (*c.current())->close())
         break;
      closeList.add( *c.current());
   }

   Paintings::cursor C( closeList);

   for_cursor( C) {
      paintings.remove( *C.current());
      delete C.current();
   }

   if( 0 == paintings.elements())
      end();
}

void PaintManager::focus()
{
   Paintings::cursor c( paintings);

   c.toFirst();
   (*c.current())->activate();
}

Settings *PaintManager::showSettings()
{
   s->showInTasklist();
   s->invoke();
   return s;
}

JProfile *PaintManager::prf()
{
   if( !_ini)
      _ini = new JProfile( "Paint.INI");
   return _ini;
}

PaintManager mgr;

// Window to do stuff
PaintMgrWindow::PaintMgrWindow()
{}

PaintMgrWindow::~PaintMgrWindow()
{}

BOOL PaintMgrWindow::handleEvents( JEventData *e)
{
   switch( e->msg) {
      case PWM_NEW:
      {
         PaintFootPrint *pfp = new( MEM_NAME) PaintFootPrint;
         mgr.newPainting( pfp->filename);
         delete pfp;
         return true;
      }
      case PWM_FOCUS:
         mgr.focus();
         return true;
   }
   return false;
}
