/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * ColourBase.hpp - common classes to the colour subsystem
 *                  See doc/Colours
 *
 * Version history: 2/3/97  First Version
 *
 */

#ifndef _colourbase_h
#define _colourbase_h

#include <JResID.hpp>
#include <JDialog.hpp>
#include <JColour.hpp>
#include <JCanvas.hpp>
// #include <JSpinBut.hpp>
#include <JSlider.hpp>

class JPaintEvent;

// Base class for colour models -----------------------------------------------
class ColourModel : public JDialog
{
 protected:
   ColourModel( JWindow *owner, const JResID &r);

 public:
   virtual ~ColourModel();
   virtual JColour current() const = 0;
   virtual void    notify( ulong who, ulong what = 0) = 0;
   BOOL closing();
};

// Base class for colour model providers --------------------------------------
class ColourModelProvider
{
 public:
   ColourModelProvider();
   virtual ~ColourModelProvider();
   virtual ColourModel *create( JWindow *owner, const JColour &def) = 0;
   virtual ulong ID() const = 0;
   virtual JStr &name() const = 0;
   virtual int operator == ( const ColourModelProvider &op2) const;
};

// Shared gui classes ---------------------------------------------------------

// A coloured area, hardlinked to id_canvas_clr of parent d
class ClrCanvas : public JCanvas
{
   JColour c;

 public:
   ClrCanvas( ColourModel *d, const JColour &c);

   const JColour &colour() const;
   JColour &colour();

   BOOL paint( JPaintEvent &e);
};

class NotifyingSlider : public JHorzSlider
{
   ColourModel *cm;

 public:
   NotifyingSlider( ColourModel *c, ulong id);

   BOOL changed();
   BOOL tracking();
};

#endif
