/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * ColourModels.hpp - colour selection models
 *                    See doc/Colours
 *
 * Version history: 2/3/97  First Version
 *
 */

#ifndef _colourmodels_h
#define _colourmodels_h

#include <JLib.h>
#include <JBorder.hpp>
#include <JStaticT.hpp>

#include "ResID.h"
#include "ColourBase.hpp"

// Naive RGB model & provider -------------------------------------------------
class NRGBModel : public ColourModel
{
   NotifyingSlider slidR;
   NotifyingSlider slidG;
   NotifyingSlider slidB;
   JStaticText     textR;
   JStaticText     textG;
   JStaticText     textB;
   ClrCanvas       clr;
   JBorder         border;

 public:
   NRGBModel( JWindow *p, const JColour &c = JColour::red);
  ~NRGBModel();

   JColour current() const;
   void    notify( ulong who, ulong what = 0);
};

class NRGBProvider : public ColourModelProvider
{
 public:
   NRGBProvider();
  ~NRGBProvider();
   ColourModel *create( JWindow *owner, const JColour &def);
   ulong ID() const;
   JStr &name() const;
};

#endif
