/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * Colours.hpp - colour management: model dialogs & manager
 *
 * Version history: 2/2/97  First Version
 *                  2/3/97  Rewrite to be funky and managed
 *
 */

#ifndef _colour_h
#define _colour_h

#include <JLib.h>
#include <JStr.hpp>
#include <JMenu.hpp>
#include <JColour.hpp>
#include <JExcept.hpp>
#include <JSet.hpp>
#include <JBag.hpp>
#include <JPtr.hpp>

#include "ColourBase.hpp"

class JComboBox;

inline const JStr &key( const ColourModelProvider &cmp) { return cmp.name(); }

typedef JKeySet<JPtr<ColourModelProvider>,JStr> CMPKeySet;

// Colour manager; encapsulates mechanics of colour picking from clients ------
class ColourManager
{
   JBag<JMenu*>               menulist;
   CMPKeySet                  cmps;
   ColourModelProvider       *current;

   JColour pick( ColourModelProvider *c, JWindow *w, const JColour &def);

 public:
   ColourManager();

   // this method is the interface to the default colour picker
   JColour pick( JWindow *owner, const JColour &def = JColour::red);
   // pick by named method
   JColour pick( char *name, JWindow *owner, const JColour &def = JColour::red);

   // fill in a menu...
   JMenu *fillMenu( JMenu *m);
   // ...or a cbox
   JComboBox *fillCBox( JComboBox *c);

   // inform when the user changes the default
   ColourManager &setDefault( char *s);
};

struct Cancelled : public JException
{
   Cancelled();
};

extern ColourManager colourMgr;

#endif
