/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * PaintMgr.hpp - A 'factory' class which looks after all paintings
 * and holds common resources, eg. the toolbox.
 *
 * Version history: 22/1/97  First Version
 *                   2/2/97  Added ini support
 *
 */

#ifndef _paintmgr_h
#define _paintmgr_h

#include <JLib.h>
#include <JShared.hpp>
#include <JMWindow.hpp>
#include <JBag.hpp>

#include "Toolbox.hpp"
#include "Painting.hpp"
#include "Settings.hpp"

class PaintMgrWindow;

class JBitmap;
class JMWindow;
class JProfile;

typedef JBag<Painting *> Paintings;

class PaintManager
{
// Toolbox         _toolbox;
   JProfile       *_ini;

   Settings       *s;
   PaintMgrWindow *patriarch;

   Paintings       paintings;

   void end();

 public:
   PaintManager();
  ~PaintManager();

   // owner of all top-level windows, used for managing multiple instances
   JWindow *father() const;

   // create new painting windows
   Painting *newPainting( char *filename);
   Painting *newPainting( const JBitmap &bmp);

   // close down a painting window
   void closeMe( Painting *p);
   void closeAllWindows();
   // set the focus somewhere sensible
   void focus();

   // get the ini
   JProfile *prf();

   // things to do with the settings
   Settings *showSettings();
   SettingsData settings;

// Toolbox &toolbox();
};

extern PaintManager mgr;

// Window for handling app messages and being everyone's owner
class PaintMgrWindow : public JMWindow
{
 public:
   PaintMgrWindow();
  ~PaintMgrWindow();

   BOOL handleEvents( JEventData *e);
};

// Shared memory class
#define MEM_NAME  "PAINTMEM"
#define PWM_NEW   0x1000
#define PWM_FOCUS 0x1001

class PaintFootPrint : public JSharedMem
{
 public:
   char  filename[ 260];
   ulong hWnd;
};

#endif
