/*
 * Paint - an image editor for OS/2 using JLib by John Fairhurst
 *
 * Painting.hpp - the frame-window class that provides the 'interface' to
 * a painting.
 *
 * Version history: 22/1/97  First Version
 *
 */

#ifndef _painting_h
#define _painting_h

#include <JLib.h>
#include <JStr.hpp>
#include <JFrame.hpp>
#include <JMouseH.hpp>
#include <JSaveDlg.hpp>

class JSize;
class JMenu;
class JViewer;
class JBitmap;
class JPSpace;
class JStatbar;
class JToolbar;
class JCmdEvent;
class JBufferedCanvas;

class Palette;
class Painting;
class Tooldata;

class PaintMouseHandler : public JMouseHandler
{
   Painting *painting;
   BOOL      active( const JPoint &p);

   BOOL      tracking;

 public:
   PaintMouseHandler( Painting *p);

   BOOL button2click( const JClickEvent &e);
   BOOL button1down( const JClickEvent &e);
   BOOL button1up( const JClickEvent &e);
   BOOL mouseMove( const JMouseEvent &e);
};

class Painting : public JFrame, public JSaveDlgClient
{
   JBufferedCanvas *picture;
   JViewer         *viewer;
   JStatbar        *statbar;
   JToolbar        *toolbar;

   JSize            activeSize;  // size of actual image, excluding padding

   JStr          name; // for saving; plus use in window title
   BOOL          datasafe;
   Palette      *palette;
   JMenu       **menus;

   Tooldata     *tooldata;

   void setup( const JBitmap &bmp);

   friend class PaintMouseHandler;
   PaintMouseHandler mouseHandler;

 public:
   Painting( const JBitmap &bmp);
   Painting( char *filename);
  ~Painting();

   BOOL closing();
   BOOL close();
   BOOL command( const JCmdEvent &e);
   Painting &show( BOOL ok = true);

   Painting &setMessage( char *s);

   JPSpace *ps() const;

   int operator == ( const Painting &op2) const;

   // Dealing with saving files
   BOOL savingImminent( JVBuffer *b, const JStr &nm, ulong id);
   void savingComplete( JVBuffer *b, ulong id, BOOL cancelled);
};


#endif
